/* ----------------------------------------------------------------------------

 Copyright (C) Sartorius Stedim Data Analytics AB 2017 -

 Use, modification and distribution are subject to the Boost Software
 License, Version 1.0. (See http://www.boost.org/LICENSE_1_0.txt)
*/

#ifndef _SQXRUNNER_H_
#define _SQXRUNNER_H_

#include <stdio.h>

#include "SIMCAQP.h"

#if defined(_WIN32) && !defined(__cplusplus)
#define strdup _strdup
#endif

#ifdef __cplusplus
extern "C" {
#endif 

   typedef struct SQRunnerStruct
   {
      char* mszUSPName;
      SQ_Project mProjectHandle;
      SQ_Model mModelHandle;
      SQ_Prediction mPredictionHandle;
      int mbAllowPythonPlugin;
   } SQRunner;

   typedef struct SQPredictionSetStruct
   {
      /* Qualitative values */
      char** mpfQualitativeValues;
      int miNumQualCols;

      /* Quantitative values */
      float* mpfQuantitativeValues;
      int miNumQuantCols;

      int miNumRows; /* Must be the same number of rows for both qualitative and quantitative values */
   } SQPredictionset;


   void SQRunner_Init(SQRunner* pObj, char* szUSPName);
   void SQRunner_Run(SQRunner* pObj);
   void SQRunner_Destroy(SQRunner* pObj);
   void SQRunner_PrintVectorData(SQ_VectorData pVectorData);

#ifdef __cplusplus
}
#endif /*__cplusplus*/

#endif
